/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.nhm.eui.NhmDataRetriever;
import ibm.nways.nhm.eui.NhmHelpRef;
import ibm.nways.nhm.eui.TimeRangeDialog;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class NhmApplet
extends Applet
implements ActionListener {
    private Calendar cal;
    private Button pbNewTimeRange;
    private Button pbHelp;
    protected NhmDataRetriever dataRetriever;
    protected int portNumber;
    protected Date startDate;
    protected Date endDate;
    protected int timeRange;
    protected int timeValue;
    protected DateFormat df = DateFormat.getDateTimeInstance(1, 1);
    private ResourceBundle appRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.AppletResources");

    public void init() {
        this.setLayout(new BorderLayout());
        this.cal = Calendar.getInstance();
        this.df.setTimeZone(TimeZone.getDefault());
    }

    protected void createDataRetriever() {
        this.dataRetriever = new NhmDataRetriever(this.getDocumentBase().getHost(), this.portNumber);
    }

    public String[] getHostParms() {
        int n;
        String[] stringArray = null;
        try {
            String string = this.getParameter("number_of_nodes");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getParameter("host_name_" + String.valueOf(n2 + 1));
            ++n2;
        }
        return stringArray;
    }

    public void getTimeParms() {
        String string = this.getParameter("time_range");
        if (string == null) {
            this.timeRange = 0;
            string = this.getParameter("end_date");
            try {
                this.endDate = this.df.parse(string);
            }
            catch (Exception exception) {
                Traces.logException(exception);
                Traces.logWarning(this, "Error parsing end date, using current date.");
                this.endDate = new Date();
            }
            string = this.getParameter("start_date");
            try {
                this.startDate = this.df.parse(string);
                return;
            }
            catch (Exception exception) {
                Traces.logException(exception);
                Traces.logWarning(this, "error parsing start date, using endDate - one day");
                this.startDate = new Date(this.endDate.getTime() - 86400000L);
                return;
            }
        }
        try {
            this.timeValue = Integer.parseInt(this.getParameter("time_length"));
        }
        catch (NumberFormatException numberFormatException) {
            this.timeValue = 1;
        }
        if (string.equals("HOURS")) {
            this.timeRange = 2;
            this.endDate = this.roundToLastHour(new Date());
            this.startDate = new Date(this.endDate.getTime() - (long)this.timeValue * 3600000L);
            return;
        }
        if (string.equals("DAYS")) {
            this.timeRange = 3;
            this.endDate = this.roundToLastDay(new Date());
            this.startDate = new Date(this.endDate.getTime() - (long)this.timeValue * 86400000L);
            return;
        }
        if (string.equals("WEEKS")) {
            int n;
            this.timeRange = 4;
            this.endDate = this.roundToLastDay(new Date());
            this.cal.setTime(this.endDate);
            int n2 = this.cal.get(7) - 1;
            if (n2 == 0) {
                n2 = 7;
            }
            try {
                n = Integer.parseInt(this.dataRetriever.getReportSetting("start_day_of_week"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
            if (n2 > n) {
                this.cal.add(5, -(n2 - n));
            } else if (n2 < n) {
                this.cal.add(5, n - n2 - 7);
            }
            this.endDate = this.cal.getTime();
            this.startDate = new Date(this.endDate.getTime() - (long)this.timeValue * 604800000L);
            return;
        }
        if (string.equals("MONTHS")) {
            this.timeRange = 5;
            this.endDate = this.roundToLastDay(new Date());
            this.cal.setTime(this.endDate);
            this.cal.add(5, 1 - this.cal.get(5));
            this.endDate = this.cal.getTime();
            this.cal.add(2, -this.timeValue);
            this.startDate = this.cal.getTime();
        }
    }

    private Date roundToLastHour(Date date) {
        this.cal.setTime(date);
        this.cal.add(12, -this.cal.get(12));
        this.cal.add(13, -this.cal.get(13));
        this.cal.add(14, -this.cal.get(14));
        return this.cal.getTime();
    }

    private Date roundToLastDay(Date date) {
        this.cal.setTime(date);
        this.cal.add(11, -this.cal.get(11));
        this.cal.add(12, -this.cal.get(12));
        this.cal.add(13, -this.cal.get(13));
        this.cal.add(14, -this.cal.get(14));
        return this.cal.getTime();
    }

    public Insets getInsets() {
        return new Insets(40, 10, 20, 10);
    }

    public void addButtons() {
        Panel panel = new Panel();
        this.pbNewTimeRange = new Button(this.appRes.getString("s_newTime"));
        panel.add(this.pbNewTimeRange);
        this.pbHelp = new Button(this.appRes.getString("s_help"));
        panel.add(this.pbHelp);
        this.add("South", panel);
        this.pbNewTimeRange.addActionListener(this);
        this.pbHelp.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pbNewTimeRange) {
            this.getNewTimeRange();
            return;
        }
        if (actionEvent.getSource() == this.pbHelp) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            this.getAppletContext().showDocument(nhmHelpRef.getURL(this));
        }
    }

    public abstract void newTimeRangeSelected();

    public void getNewTimeRange() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        Frame frame = (Frame)container;
        TimeRangeDialog timeRangeDialog = new TimeRangeDialog(this, frame, this.appRes.getString("s_timeTitle"), this.startDate, this.timeRange, this.timeValue);
        timeRangeDialog.show();
        if (timeRangeDialog.getResult() != 2) {
            this.startDate = timeRangeDialog.getStartDate();
            if (timeRangeDialog.getTimeRange() == 0) {
                this.endDate = timeRangeDialog.getEndDate();
            } else {
                int n = timeRangeDialog.getTimeLength();
                switch (timeRangeDialog.getTimeRange()) {
                    case 2: {
                        this.endDate = new Date(this.startDate.getTime() + (long)n * 3600000L);
                        break;
                    }
                    case 3: {
                        this.endDate = new Date(this.startDate.getTime() + (long)n * 86400000L);
                        break;
                    }
                    case 4: {
                        this.endDate = new Date(this.startDate.getTime() + (long)n * 604800000L);
                        break;
                    }
                    case 5: {
                        this.cal.setTime(this.startDate);
                        this.cal.add(2, n);
                        this.endDate = this.cal.getTime();
                        break;
                    }
                }
            }
            this.newTimeRangeSelected();
        }
    }
}

